#include <bits/stdc++.h>

using namespace std;


struct point{
    long long int x, y;
};


vector<point> ret_hull;


int orientation(point a, point b, point c){
    long long int s = a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y);
    if (s < 0) return -1;
    if (s > 0) return 1;
    return 0;
}


long long int t_surf(point a, point b, point c){
    return abs((b.x - a.x) * (c.y - b.y) - (c.x - b.x) * (b.y - a.y)) >> 1;
}


long long int find_hull(vector<point>& points, bool get_points){
    int n = points.size();
    point op = points[0];
    for (int i = 1; i < n; i++){
        if (points[i].y < op.y) op = points[i];
        else if (points[i].y == op.y && points[i].x < op.x) op = points[i];
    }
    sort(points.begin(), points.end(), [&op](const point& a, const point& b){
         if (a.x == op.x && a.y == op.y) return true;
         else if (b.x == op.x && b.y == op.y) return false;
         else return orientation(op, a, b) < 0;
    });
    vector<point> hull;
    for (int i = 0; i < n; i++){
        while (hull.size() > 1 && !(orientation(hull[hull.size() - 2], hull.back(), points[i]) < 0)){
            hull.pop_back();
        }
        hull.push_back(points[i]);
    }
    if (get_points){
        ret_hull.clear();
        for (point p : hull) ret_hull.push_back(p);
    }
    long long int surf = 0;
    for (int i = 2; i < hull.size(); i++) surf += t_surf(hull[i], hull[i - 1], hull[0]);
    return surf;
}


int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int n;
    cin >> n;
    vector<point> points(n);
    for (int i = 0; i < n; i++) cin >> points[i].x >> points[i].y;
    long long int og_surf = find_hull(points, true);
    int cn = ret_hull.size();
    vector<point> no_first;
    for (int i = 1; i < n; i++) no_first.push_back(points[i]);
    long long int best_surf = find_hull(no_first, false);
    // Lude stvari krecu ovde
    vector<int> hinp(cn);
    int hp = 0;
    for (int i = 0; i < n; i++){
        if (points[i].x == ret_hull[hp].x && points[i].y == ret_hull[hp].y){
            hinp[hp] = i;
            hp++;
        }
        if (hp == cn) break;
    }
    // window stuff, j je ovaj koga izbacujemo
    for (int j = 1; j < cn; j++){
        int go_to = n - 1;
        if (j + 1 < cn) go_to = hinp[j + 1];
        vector<point> temp_hull;
        for (int i = hinp[j - 1]; i <= go_to; i++){
            if (i == hinp[j]) continue;
            while (temp_hull.size() > 1 && !(orientation(temp_hull[temp_hull.size() - 2], temp_hull.back(), points[i]) < 0)){
                temp_hull.pop_back();
            }
            temp_hull.push_back(points[i]);
        }
        if (go_to == n - 1) temp_hull.push_back(points[0]);
        long long int temp_surf = 0;
        for (int i = 1; i < temp_hull.size(); i++) temp_surf += t_surf(temp_hull[i], temp_hull[i - 1], ret_hull[0]);
        long long int old_2_triangles = t_surf(ret_hull[0], ret_hull[j], ret_hull[j - 1]) + t_surf(ret_hull[0], ret_hull[j], ret_hull[(j + 1) % cn]);
        best_surf = min(best_surf, og_surf - old_2_triangles + temp_surf);
    }
    cout << best_surf << endl;
    return 0;
}